/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcinterface1201.BuilderGUI;
import mcinterface1201.WrapperItemStack;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPackMissing;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfaceClient;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InterfaceClient
implements IInterfaceClient {
    private static CameraSystem.CameraMode actualCameraMode;
    private static CameraSystem.CameraMode cameraModeRequest;
    private static int ticksToCullingWarning;
    private static final Point3D mutablePosition;

    @Override
    public boolean isGamePaused() {
        return Minecraft.m_91087_().m_91104_();
    }

    @Override
    public String getLanguageName() {
        if (Minecraft.m_91087_().m_91102_() != null) {
            return Minecraft.m_91087_().m_91102_().m_264236_();
        }
        return "en_us";
    }

    @Override
    public List<String> getAllLanguages() {
        ArrayList<String> list = new ArrayList<String>();
        Minecraft.m_91087_().m_91102_().m_264450_().forEach((languageCode, languageInfo) -> list.add((String)languageCode));
        return list;
    }

    @Override
    public String getFluidName(String fluidID, String fluidMod) {
        for (Map.Entry fluidEntry : ForgeRegistries.FLUIDS.getEntries()) {
            ResourceLocation fluidLocation = ((ResourceKey)fluidEntry.getKey()).m_135782_();
            if (!fluidMod.equals("wildcard") && !fluidLocation.m_135827_().equals(fluidMod) || !fluidLocation.m_135815_().equals(fluidID)) continue;
            return ((Fluid)fluidEntry.getValue()).getFluidType().getDescription().getString();
        }
        return "INVALID";
    }

    @Override
    public Map<String, String> getAllFluidNames() {
        HashMap<String, String> fluidIDsToNames = new HashMap<String, String>();
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            fluidIDsToNames.put(ForgeRegistries.FLUIDS.getKey((Object)fluid).m_135815_(), new FluidStack(fluid, 1).getDisplayName().getString());
        }
        return fluidIDsToNames;
    }

    @Override
    public boolean isChatOpen() {
        return Minecraft.m_91087_().f_91080_ instanceof ChatScreen;
    }

    @Override
    public boolean isGUIOpen() {
        return Minecraft.m_91087_().f_91080_ != null;
    }

    @Override
    public CameraSystem.CameraMode getCameraMode() {
        return actualCameraMode;
    }

    @Override
    public void setCameraMode(CameraSystem.CameraMode mode) {
        cameraModeRequest = mode;
    }

    @Override
    public int getCameraDefaultZoom() {
        return 0;
    }

    @Override
    public long getPackedDisplaySize() {
        return (long)Minecraft.m_91087_().m_91268_().m_85445_() << 32 | (long)Minecraft.m_91087_().m_91268_().m_85446_() & 0xFFFFFFFFL;
    }

    @Override
    public float getFOV() {
        return ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
    }

    @Override
    public void setFOV(float setting) {
        ((Ifov)Minecraft.m_91087_().f_91066_.m_231837_()).setManual((int)setting);
    }

    @Override
    public float getMouseSensitivity() {
        return ((Double)Minecraft.m_91087_().f_91066_.m_231964_().m_231551_()).floatValue();
    }

    @Override
    public void setMouseSensitivity(float setting) {
        Minecraft.m_91087_().f_91066_.m_231964_().m_231514_((Object)setting);
    }

    @Override
    public void closeGUI() {
        Minecraft.m_91087_().m_91152_(null);
    }

    @Override
    public void setActiveGUI(AGUIBase gui) {
        Minecraft.m_91087_().m_91152_((Screen)new BuilderGUI(gui));
    }

    @Override
    public WrapperWorld getClientWorld() {
        return WrapperWorld.getWrapperFor((Level)Minecraft.m_91087_().f_91073_);
    }

    @Override
    public WrapperPlayer getClientPlayer() {
        return WrapperPlayer.getWrapperFor((Player)Minecraft.m_91087_().f_91074_);
    }

    @Override
    public Point3D getCameraPosition() {
        Vec3 cameraOffset = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        mutablePosition.set(cameraOffset.f_82479_, cameraOffset.f_82480_, cameraOffset.f_82481_);
        return mutablePosition;
    }

    @Override
    public void playBlockBreakSound(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        if (!Minecraft.m_91087_().f_91073_.m_46859_(pos)) {
            SoundType soundType = Minecraft.m_91087_().f_91073_.m_8055_(pos).m_60734_().getSoundType(Minecraft.m_91087_().f_91073_.m_8055_(pos), (LevelReader)Minecraft.m_91087_().f_91074_.m_9236_(), pos, null);
            Minecraft.m_91087_().f_91073_.m_5594_((Player)Minecraft.m_91087_().f_91074_, pos, soundType.m_56775_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
        }
    }

    @Override
    public List<String> getTooltipLines(IWrapperItemStack stack) {
        ArrayList<String> tooltipText = new ArrayList<String>();
        List tooltipLines = ((WrapperItemStack)stack).stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        for (int i = 0; i < tooltipLines.size(); ++i) {
            Component component = (Component)tooltipLines.get(i);
            Style style = component.m_7383_();
            Object stringToAdd = "";
            if (style.m_131154_()) {
                stringToAdd = (String)stringToAdd + "275";
            }
            if (style.m_131161_()) {
                stringToAdd = (String)stringToAdd + "278";
            }
            if (style.m_131171_()) {
                stringToAdd = (String)stringToAdd + "277";
            }
            if (style.m_131168_()) {
                stringToAdd = (String)stringToAdd + "276";
            }
            if (style.m_131176_()) {
                stringToAdd = (String)stringToAdd + "274";
            }
            if (style.m_131135_() != null) {
                ChatFormatting legacyColor = null;
                for (ChatFormatting format : ChatFormatting.values()) {
                    if (!format.m_126664_() || !style.m_131135_().equals((Object)TextColor.m_131270_((ChatFormatting)format))) continue;
                    legacyColor = format;
                    break;
                }
                if (legacyColor != null) {
                    stringToAdd = (String)stringToAdd + "\u00a7" + Integer.toHexString(legacyColor.ordinal());
                }
            }
            tooltipText.add((String)stringToAdd + ((Component)tooltipLines.get(i)).getString());
        }
        return tooltipText;
    }

    @SubscribeEvent
    public static void onIVClientTick(TickEvent.ClientTickEvent event) {
        AWrapperWorld world;
        IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
        if (!InterfaceManager.clientInterface.isGamePaused() && player != null && (world = InterfaceManager.clientInterface.getClientWorld()) != null) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                if (!player.isSpectator()) {
                    ControlSystem.controlGlobal(player);
                    if (((WrapperPlayer)player).player.f_19797_ % 100 == 0 && !InterfaceManager.clientInterface.isGUIOpen() && !PackParser.arePacksPresent()) {
                        new GUIPackMissing();
                    }
                }
                ((WrapperWorld)world).world.m_46465_();
                world.tickAll(true);
                if (((Boolean)ConfigSystem.settings.general.performModCompatFunctions.value).booleanValue() && InterfaceManager.coreInterface.isModPresent("entityculling") && ticksToCullingWarning > 0 && --ticksToCullingWarning == 0) {
                    player.displayChatMessage(LanguageSystem.SYSTEM_DEBUG, "IV HAS DETECTED THAT ENTITY CULLING MOD IS PRESENT.  THIS MOD CULLS ALL IV VEHICLES UNLESS \"mts:builder_existing\", \"mts:builder_rendering\", AND \"mts:builder_seat\" ARE ADDED TO THE WHITELIST.");
                }
            } else {
                world.tickAll(false);
                if (cameraModeRequest != null) {
                    switch (cameraModeRequest) {
                        case FIRST_PERSON: {
                            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
                            break;
                        }
                        case THIRD_PERSON: {
                            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
                            break;
                        }
                        case THIRD_PERSON_INVERTED: {
                            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_FRONT);
                        }
                    }
                    cameraModeRequest = null;
                }
                CameraType cameraModeEnum = Minecraft.m_91087_().f_91066_.m_92176_();
                switch (cameraModeEnum) {
                    case FIRST_PERSON: {
                        actualCameraMode = CameraSystem.CameraMode.FIRST_PERSON;
                        break;
                    }
                    case THIRD_PERSON_BACK: {
                        actualCameraMode = CameraSystem.CameraMode.THIRD_PERSON;
                        break;
                    }
                    case THIRD_PERSON_FRONT: {
                        actualCameraMode = CameraSystem.CameraMode.THIRD_PERSON_INVERTED;
                    }
                }
            }
        }
    }

    static {
        ticksToCullingWarning = 200;
        mutablePosition = new Point3D();
    }

    public static interface Ifov {
        public void setManual(Integer var1);
    }
}

